---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.5
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 5, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Corrected sp_SEL_USER_SPORTS, changed LANGUAGE_ID to SPORTS_ID 
-- MSW 092700 Corrected sp_SEL_UserID_By_Screenname, added % for like condition
-- MSW 092700 Deleted PROCEDURE sp_UPD_USER_DEMOGRAPHICS
-- MSW 092700 Changed PROCEDURE sp_INS_USER_DETAIL to incorporate demographics deleted in procedue sp_UPD_USER_DEMOGRAPHICS
-- MSW 092700 Changed PROCEDURE sp_UPD_USER_DETAIL to incorporate demographics deleted in procedue sp_UPD_USER_DEMOGRAPHICS
-- MSW 092700 Deleted PROCEDURE sp_SEL_USER_DEMOGRAPHICS
-- MSW 092700 Changed PROCEDURE sp_SEL_USER_DETAIL to incorporate demographics deleted in procedue sp_SEL_USER_DEMOGRAPHICS
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 100300 Removed ERROR_CODEs(6519, 6520) from pkg_ALKINDI_USER.sp_INS_USER_INTEREST
-- MSW 100300 Removed ERROR_CODEs(6521, 6522) from pkg_ALKINDI_USER.sp_INS_USER_ACTIVITY
-- MSW 100300 Removed ERROR_CODEs(6523, 6524) from pkg_ALKINDI_USER.sp_INS_USER_PROFESSION
-- MSW 100300 Removed ERROR_CODEs(6525, 6526) from pkg_ALKINDI_USER.sp_INS_USER_MOVIE_GENRE
-- MSW 100300 Removed ERROR_CODEs(6527, 6528) from pkg_ALKINDI_USER.sp_INS_USER_SPORTS
-- MSW 100300 Removed ERROR_CODEs(6529, 6530) from pkg_ALKINDI_USER.sp_INS_USER_LANGUAGE
-- MSW 100300 Removed ERROR_CODE(6552) from pkg_ALKINDI_USER.sp_INSERT_Evals
-- MSW 100300 Changed pkg_ALKINDI_USER.sp_INSERT_Evals to insert into the ERRORS table when an exception occurs
-- MSW 100500 Corrected pkg_ALKINDI_USER.sp_VERIFY_LOGIN_PASSWORD, SQL Statement was selecting values into wrong variables
---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_USER
AS
  TYPE USER_cursor_type is REF CURSOR;

  PROCEDURE sp_CREATE_USER_ID(
	io_USER_ID 			IN OUT 	USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_VERIFY_LOGIN_PASSWORD(
 	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
 	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
      o_USER_ID 			OUT 		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_VERIFY_UNIQUE_SCREENNAME(						-- MSW 09252000
 	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SELECT_QUESTION_ID(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_QUESTION1			OUT		USER_DETAIL.QUESTION1%TYPE,
	o_QUESTION2			OUT		USER_DETAIL.QUESTION2%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_VERIFY_QUESTION_ANSWER(
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	o_USER_ID			OUT		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SELECT_PASSWORD(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_PASSWORD			OUT		USER_DETAIL.PASSWORD%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_UPDATE_USER_STATUS_ID(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_USER_STATUS_ID		IN		USER_DETAIL.USER_STATUS_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_UPDATE_PASSWORD(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_USER_PASSWORD_OLD	IN		USER_DETAIL.PASSWORD%TYPE,
	i_USER_PASSWORD_NEW	IN		USER_DETAIL.PASSWORD%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_INS_FRIEND_EMAIL(
	i_USER_ID			IN		USER_FRIEND_EMAIL.USER_ID%TYPE,
	i_FRIEND_EMAIL		IN		USER_FRIEND_EMAIL.FRIEND_EMAIL%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_INS_USER_MY_LIST(
	i_USER_ID			IN		USER_MY_LIST.USER_ID%TYPE,
	i_PRODUCT_ID		IN		USER_MY_LIST.PRODUCT_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_INS_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	i_HOME_ZIP_CODE		IN		USER_DETAIL.HOME_ZIP_CODE%TYPE,
	i_SEX_ID			IN		USER_DETAIL.SEX_ID%TYPE,
	i_BIRTHDATE			IN		USER_DETAIL.BIRTHDATE%TYPE,
	i_WEEKLY_ENT_EXP		IN		USER_DETAIL.WEEKLY_ENT_EXP%TYPE,
	o_ERROR_CODE		OUT		NUMBER);
		
  PROCEDURE sp_INS_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_INTEREST_ID		IN		REL_USER_INTEREST.INTEREST_ID%TYPE);

  PROCEDURE sp_INS_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_ACTIVITY_ID		IN		REL_USER_ACTIVITY.ACTIVITY_ID%TYPE);

  PROCEDURE sp_INS_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_PROFESSION_ID		IN		REL_USER_PROFESSION.PROFESSION_ID%TYPE);

  PROCEDURE sp_INS_USER_MOVIE_GENRE(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	i_MOVIE_GENRE_ID		IN		REL_USER_MOVIE_GENRE.MOVIE_GENRE_ID%TYPE);

  PROCEDURE sp_INS_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_SPORTS_ID			IN		REL_USER_SPORTS.SPORTS_ID%TYPE);

  PROCEDURE sp_INS_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_LANGUAGE_ID		IN		REL_USER_LANGUAGE.LANGUAGE_ID%TYPE);

  PROCEDURE sp_UPD_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	i_HOME_ZIP_CODE		IN		USER_DETAIL.HOME_ZIP_CODE%TYPE,
	i_SEX_ID			IN		USER_DETAIL.SEX_ID%TYPE,
	i_BIRTHDATE			IN		USER_DETAIL.BIRTHDATE%TYPE,
	i_WEEKLY_ENT_EXP		IN		USER_DETAIL.WEEKLY_ENT_EXP%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_MovieGenre(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_MovieGenre(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

END pkg_ALKINDI_USER;
/

SHOW ERRORS


-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_USER
AS
 PROCEDURE sp_CREATE_USER_ID (
	io_USER_ID			IN OUT	USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	SELECT sq_USER_ID.NEXTVAL INTO io_USER_ID FROM DUAL;

	INSERT INTO USER_ID (USER_ID, DATE_CREATED)
	VALUES(io_USER_ID, sysdate);

	IF SQL%NOTFOUND THEN 
		io_USER_ID	 :=  0;
		o_ERROR_CODE := 6500;
	ELSE
		o_ERROR_CODE :=  0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6501;
	io_USER_ID		:= 0;
 END sp_CREATE_USER_ID;

-- ==========================================================================================

 PROCEDURE sp_VERIFY_LOGIN_PASSWORD(
 	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
 	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
      o_USER_ID 			OUT 		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS
	v_USER_STATUS_ID NUMBER;
   BEGIN
      SELECT USER_ID,USER_STATUS_ID INTO o_USER_ID, v_USER_STATUS_ID
        FROM USER_DETAIL
	 WHERE EMAIL = i_EMAIL
	   AND PASSWORD = i_PASSWORD;

	IF v_USER_STATUS_ID = 4 THEN 
		o_ERROR_CODE:= 6502;
	ELSE
		o_ERROR_CODE:= 0;
	END IF; 

   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6503;
		o_USER_ID		:= 0;
 END sp_VERIFY_LOGIN_PASSWORD;

-- ==========================================================================================

  PROCEDURE sp_VERIFY_UNIQUE_SCREENNAME(						-- MSW 09252000
 	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
  IS 
	v_SCREENNAME_COUNT NUMBER;
  BEGIN

	SELECT COUNT(SCREENNAME) INTO v_SCREENNAME_COUNT
	  FROM USER_DETAIL
	 WHERE SCREENNAME = i_SCREENNAME;

	IF v_SCREENNAME_COUNT > 0 THEN 
		o_ERROR_CODE:= 6504;
	ELSE
		o_ERROR_CODE:= 0;
	END IF; 

  EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6505;
  END sp_VERIFY_UNIQUE_SCREENNAME;

-- ==========================================================================================

 PROCEDURE sp_SELECT_QUESTION_ID(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_QUESTION1			OUT		USER_DETAIL.QUESTION1%TYPE,
	o_QUESTION2			OUT		USER_DETAIL.QUESTION2%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
  IS BEGIN
	o_ERROR_CODE:= 0;

	SELECT QUESTION1, QUESTION2 INTO o_QUESTION1, o_QUESTION2
	  FROM USER_DETAIL
	 WHERE USER_ID = i_USER_ID;

  EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6506;
  END sp_SELECT_QUESTION_ID;

-- ==========================================================================================

  PROCEDURE sp_VERIFY_QUESTION_ANSWER(
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	o_USER_ID			OUT		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE:= 0;

	SELECT USER_ID INTO o_USER_ID
	  FROM USER_DETAIL
	 WHERE EMAIL = i_EMAIL
	   AND QUESTION1 = i_QUESTION1
	   AND ANSWER1 = i_ANSWER1
	   AND QUESTION2 = i_QUESTION2
	   AND ANSWER2 = i_ANSWER2;

  EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6507;
  END sp_VERIFY_QUESTION_ANSWER;

-- ==========================================================================================

  PROCEDURE sp_SELECT_PASSWORD(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_PASSWORD			OUT		USER_DETAIL.PASSWORD%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE:= 0;

	SELECT PASSWORD INTO o_PASSWORD
	  FROM USER_DETAIL
	 WHERE USER_ID = i_USER_ID;

  EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6508;
  END sp_SELECT_PASSWORD;

-- ==========================================================================================

  PROCEDURE sp_UPDATE_USER_STATUS_ID(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_USER_STATUS_ID		IN		USER_DETAIL.USER_STATUS_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	UPDATE USER_DETAIL
	   SET USER_STATUS_ID = i_USER_STATUS_ID
	 WHERE USER_ID = i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6509;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6510;
  END sp_UPDATE_USER_STATUS_ID;

-- ==========================================================================================

  PROCEDURE sp_UPDATE_PASSWORD(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_USER_PASSWORD_OLD	IN		USER_DETAIL.PASSWORD%TYPE,
	i_USER_PASSWORD_NEW	IN		USER_DETAIL.PASSWORD%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	UPDATE USER_DETAIL
	   SET PASSWORD = i_USER_PASSWORD_NEW
	 WHERE USER_ID = i_USER_ID
	   AND PASSWORD = i_USER_PASSWORD_OLD;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6511;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6512;
  END sp_UPDATE_PASSWORD;

-- ==========================================================================================

  PROCEDURE sp_INS_FRIEND_EMAIL(
	i_USER_ID			IN		USER_FRIEND_EMAIL.USER_ID%TYPE,
	i_FRIEND_EMAIL		IN		USER_FRIEND_EMAIL.FRIEND_EMAIL%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN

	INSERT INTO USER_FRIEND_EMAIL
	VALUES (i_USER_ID, i_FRIEND_EMAIL, sysdate);

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6513;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6514;
  END sp_INS_FRIEND_EMAIL;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_MY_LIST(
	i_USER_ID			IN		USER_MY_LIST.USER_ID%TYPE,
	i_PRODUCT_ID		IN		USER_MY_LIST.PRODUCT_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN

	INSERT INTO USER_MY_LIST
	VALUES (i_USER_ID, i_PRODUCT_ID, sysdate);

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6515;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6516;
  END sp_INS_USER_MY_LIST;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	i_HOME_ZIP_CODE		IN		USER_DETAIL.HOME_ZIP_CODE%TYPE,
	i_SEX_ID			IN		USER_DETAIL.SEX_ID%TYPE,
	i_BIRTHDATE			IN		USER_DETAIL.BIRTHDATE%TYPE,
	i_WEEKLY_ENT_EXP		IN		USER_DETAIL.WEEKLY_ENT_EXP%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN

	INSERT INTO USER_DETAIL (USER_ID, EMAIL, SCREENNAME, PASSWORD, QUESTION1, ANSWER1, QUESTION2, ANSWER2, HOME_ZIP_CODE, SEX_ID, BIRTHDATE, WEEKLY_ENT_EXP)
	VALUES (i_USER_ID, i_EMAIL, i_SCREENNAME, i_PASSWORD, i_QUESTION1, i_ANSWER1, i_QUESTION2, i_ANSWER2, i_HOME_ZIP_CODE, i_SEX_ID, i_BIRTHDATE, i_WEEKLY_ENT_EXP);

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6517;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6518;
  END sp_INS_USER_DETAIL;

-- ==========================================================================================
		
  PROCEDURE sp_INS_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_INTEREST_ID		IN		REL_USER_INTEREST.INTEREST_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_INTEREST
	VALUES (i_USER_ID, i_INTEREST_ID);

  END sp_INS_USER_INTEREST;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_ACTIVITY_ID		IN		REL_USER_ACTIVITY.ACTIVITY_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_ACTIVITY
	VALUES (i_USER_ID, i_ACTIVITY_ID);

  END sp_INS_USER_ACTIVITY;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_PROFESSION_ID		IN		REL_USER_PROFESSION.PROFESSION_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_PROFESSION
	VALUES (i_USER_ID, i_PROFESSION_ID);

  END sp_INS_USER_PROFESSION;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_MOVIE_GENRE(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	i_MOVIE_GENRE_ID		IN		REL_USER_MOVIE_GENRE.MOVIE_GENRE_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_MOVIE_GENRE
	VALUES (i_USER_ID, i_MOVIE_GENRE_ID);

  END sp_INS_USER_MOVIE_GENRE;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_SPORTS_ID			IN		REL_USER_SPORTS.SPORTS_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_SPORTS
	VALUES (i_USER_ID, i_SPORTS_ID);

  END sp_INS_USER_SPORTS;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_LANGUAGE_ID		IN		REL_USER_LANGUAGE.LANGUAGE_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_LANGUAGE
	VALUES (i_USER_ID, i_LANGUAGE_ID);

  END sp_INS_USER_LANGUAGE;

-- ==========================================================================================

  PROCEDURE sp_UPD_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	i_HOME_ZIP_CODE		IN		USER_DETAIL.HOME_ZIP_CODE%TYPE,
	i_SEX_ID			IN		USER_DETAIL.SEX_ID%TYPE,
	i_BIRTHDATE			IN		USER_DETAIL.BIRTHDATE%TYPE,
	i_WEEKLY_ENT_EXP		IN		USER_DETAIL.WEEKLY_ENT_EXP%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN

	UPDATE USER_DETAIL
	   SET USER_ID=i_USER_ID
	     , EMAIL=i_EMAIL
	     , SCREENNAME=i_SCREENNAME
	     , PASSWORD=i_PASSWORD
	     , QUESTION1=i_QUESTION1
	     , ANSWER1=i_ANSWER1
	     , QUESTION2=i_QUESTION2
	     , ANSWER2=i_ANSWER2
	     , HOME_ZIP_CODE=i_HOME_ZIP_CODE
	     , SEX_ID=i_SEX_ID
	     , BIRTHDATE=i_BIRTHDATE
	     , WEEKLY_ENT_EXP=i_WEEKLY_ENT_EXP
	 WHERE USER_ID = i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6531;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6532;
  END sp_UPD_USER_DETAIL;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_INTEREST
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6533;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6534;
   END sp_DEL_USER_INTEREST;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_ACTIVITY
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6535;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6536;
  END sp_DEL_USER_ACTIVITY;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_PROFESSION
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6537;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6538;
  END sp_DEL_USER_PROFESSION;

-- ==========================================================================================

  PROCEDURE sp_DEL_MovieGenre(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_MOVIE_GENRE
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6539;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6540;
  END sp_DEL_MovieGenre;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_SPORTS
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6541;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6542;
  END sp_DEL_USER_SPORTS;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_LANGUAGE
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6543;
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6544;
   END sp_DEL_USER_LANGUAGE;

-- ==========================================================================================

   PROCEDURE sp_SEL_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR
	 SELECT USER_ID, EMAIL, SCREENNAME, PASSWORD, QUESTION1, ANSWER1
	      , QUESTION2, ANSWER2, HOME_ZIP_CODE, SEX_ID, BIRTHDATE, WEEKLY_ENT_EXP
	   FROM USER_DETAIL
	  WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6545;
   END sp_SEL_USER_DETAIL;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR
	SELECT INTEREST_ID
	  FROM REL_USER_INTEREST
	 WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6546;
  END sp_SEL_USER_INTEREST;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR
	SELECT ACTIVITY_ID
	  FROM REL_USER_ACTIVITY
	 WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6547;
   END sp_SEL_USER_ACTIVITY;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR
	SELECT PROFESSION_ID
	  FROM REL_USER_PROFESSION
	 WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6548;
   END sp_SEL_USER_PROFESSION;

-- ==========================================================================================

  PROCEDURE sp_SEL_MovieGenre(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR

	SELECT MOVIE_GENRE_ID
	  FROM REL_USER_MOVIE_GENRE
	 WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6549;
		CLOSE o_USER_cursor_type;
 END sp_SEL_MovieGenre;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR

	SELECT SPORTS_ID
	  FROM REL_USER_SPORTS
	 WHERE USER_ID = i_USER_ID;


   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6550;
   END sp_SEL_USER_SPORTS;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_LANGUAGE(

	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR

	SELECT LANGUAGE_ID
	  FROM REL_USER_LANGUAGE
	 WHERE USER_ID = i_USER_ID;


   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6551;
   END sp_SEL_USER_LANGUAGE;

-- ==========================================================================================

END pkg_ALKINDI_USER;
/

SHOW ERRORS
